;**********************************************************
; TEST DES CAPTEURS  Robopoly  Janvier 04
;**********************************************************
; Le programme suivant allume la LED lorsque le capteur
; dtecte qqch. (Ceci vous permettra de tester vos soudures
; et la porte de vos capteurs)
;**********************************************************
; MONTAGE:
; Sortie du capteur monte sur le port B4, 0: obstacle 
; dtect, 1 : rien en vue
; La LED est sur le port B2, 0: LED allume, 1: LED teinte
;**********************************************************

; INITIALISATIONS:

.include "8535def.inc"
.include "definitions.asm"
.include "macros.asm"

reset:
	ldi	r16, 0b00001111		; Capteurs: B4 en entre
	out	DDRB, r16		; Led : B2 en sortie
	ldi	r16, 0xff		; Eteindre la led
	out	PORTB, r16


; PROGRAMME PRINCIPAL:	

main:
	in	r16, PINB		; Lis la valeur du capteur
	sbrs	r16, 4			; Skip if bit in register is set
					; Saute la ligne suivante si le
					; bit 4 de r16 vaut 1
	rjmp allumer_led		; 
	rjmp	main


allumer_led:
	ldi	r16, 0x00		; met un 0 pour allumer
	out 	PORTB, r16
	WAIT_MS	1			; attend
	ldi	r16, 0xff		; met un 1 pour teindre
	out	PORTB, r16
	rjmp	main				

;**********************************************************
